dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 4, 270, 250, "assets/images/table/island", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 4, 175, 400, "assets/images/table/island", "assets/images/food/item_mark2", "B" );
LManager:AddNewTable( 3, 4, 400, 400, "assets/images/table/island", "assets/images/food/item_mark1", "B" );


useFloAsServer = 1;
useWineTable = 1;
numMoodBoosts = 2;
numServers = 1;
maxCoupleHappiness = 400;

-- Group 1

guest = LManager.GenGuest(male01);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female01;
guest.percentRequestDrink = 20;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 5, 3000);


-- Group 2


guest = LManager.GenGuest(male04);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = NOT_GUEST + uncle;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table3;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(6, 10, 20000);


-- Group 3

guest = LManager.GenGuest(male02);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + female02;
guest.percentRequestMusic = 20;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(11, 12, 40000);

-- Group 4

guest = LManager.GenGuest(male03);
guest.likes={male04};
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.likes={male04};
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(13, 14, 66000);

-- Group 5

guest = LManager.GenGuest(male03);
guest.likes={male02};
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.likes={male02};
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(15, 16, 80000);


-- Group 5

guest = LManager.GenGuest(male03);
guest.matchType = table3;
guest.percentRequestMusic = 20;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = NOT_GUEST + male03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(17, 18, 120000);

-- Group 6


guest = LManager.GenGuest(male01);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = male02;
guest.percentRequestDrink = 20;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(19, 22, 150000);


-- Group 7

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(23, 23, 190000);

-- Group 8

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(24, 24, 206000);


LManager:AdjustGuestTolerance(140);

LManager:SetLevelSetting ("cakeTipDelay", 100000); 
LManager:SetLevelSetting ("cakeTipChance", 100);

LManager:SetLevelSetting ("speakerDelay", 130000); 
LManager:SetLevelSetting ("speakerChance", 50);

LManager:AddQuinnEvent( "fx/fx_bees.lua", 600, 300, 70000 );

LManager:AddReseatingRequestForGuest(115000, male03);
LManager:AddReseatingRequestForGuest(160000, male03);
LManager:AddReseatingRequestForGuest(200000, male03);
LManager:AddReseatingRequestForGuest(230000, male03);

-- Set up the Level Settings
LManager:SetLevelNumber(4,6);
LManager:SetLevelScores(9200, 13000);
LManager:SetLevelTime(300000);

LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 4.ogg","assets/audio/music/Uptempo 1.ogg","assets/audio/music/Disco Dance 1.ogg");
LManager:SetBackgroundImage("assets/images/bg_island");
LManager:SetChairImage("assets/images/table/chair04");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );